# -*- coding: utf-8 -*-

import os
import socket
import sys

sys.path.append(os.path.join(os.path.abspath(os.path.dirname(__file__)), 'webroot'))


def current_ip():
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.connect(("8.8.8.8", 80))
    ip = s.getsockname()[0]
    s.close()
    return ip


class Consul(object):
    def __init__(self, url):
        self._url = url

    @property
    def url(self):
        return "{}/v1/agent/service/register".format(self._url)

    def register_device(self, name, addr, port: int):
        data = {
            "ID": "{}".format(name),
            "Name": name,
            "Address": addr,
            "Port": int(port),
        }
        header = {"Authorization": "Basic  bWljcm8tY29uc3VsLWFnZW50OjEyMzQ1Ng=="}
        from app.base.logger import log
        log.i(self.url)
        log.i(data)
        import requests
        resp = requests.put(self.url, headers=header, json=data)
        log.i('register_device %s %s', resp.status_code, resp.text)
        return resp.status_code == 200


def main():
    from app.app_env import PATH_APP_ROOT, PATH_DATA
    from app.base.webapp import tp_web_app
    _web_app = tp_web_app()
    if not _web_app.init(PATH_APP_ROOT, PATH_DATA):
        return 1
    # from app.base.configs import tp_cfg
    # cfg = tp_cfg()
    # consul_host = cfg.plugin.consul
    # Consul(consul_host).register_device('micro-remote', current_ip(), 7190)
    return _web_app.run()


if __name__ == '__main__':
    sys.exit(main())
