package com.example.simboxapi.data

import androidx.lifecycle.LiveData
import androidx.lifecycle.liveData
import com.example.simboxapi.base.BaseResponse
import com.example.simboxapi.data.api.ApiService
import com.example.simboxapi.data.entirys.CountryDataBean
import com.example.simboxapi.data.entirys.OnOffImisDataBean
import kotlinx.coroutines.Dispatchers
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody.Companion.toRequestBody
import org.json.JSONArray
import org.json.JSONObject
import java.lang.Exception

class ViewModelRepository(private val apiService: ApiService) {

    companion object {
        fun getInstance(apiService: ApiService): ViewModelRepository {
            return ViewModelRepository(apiService)
        }
    }

    private fun <T> execute(function: suspend () -> T): LiveData<ResourceViewModel<T>> {
        return liveData(Dispatchers.IO) {
            emit(ResourceViewModel.loading(data = null))
            try {
                emit(ResourceViewModel.success(function()!!))
            } catch (e: Exception) {
                emit(ResourceViewModel.error(data = null, e = e))
            }
        }
    }

    fun apiPostQueryCountryInfo(langType: String, loginCustomerId: String, partnerCode: String, streamNo: String, cookie: String, voipId: String): LiveData<ResourceViewModel<BaseResponse<ArrayList<CountryDataBean>>>> {
        val jsonObject = JSONObject()
        jsonObject.put("langType", langType)
        jsonObject.put("loginCustomerId", loginCustomerId)
        jsonObject.put("partnerCode", partnerCode)
        jsonObject.put("streamNo", streamNo)
        val body = jsonObject.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return execute { apiService.apiQueryCountryInfo(body, cookie, voipId) }
    }

    fun apiPostOnOffImsi(imei: String, loginCustomerId: String, offImsiList: ArrayList<String>, onImsiList: ArrayList<String>, partnerCode: String, streamNo: String, cookie: String, voipId: String, userLabel: String): LiveData<ResourceViewModel<BaseResponse<ArrayList<OnOffImisDataBean>>>> {
        val jsonObject = JSONObject()
        jsonObject.put("imei", imei)
        jsonObject.put("loginCustomerId", loginCustomerId)
        jsonObject.put("offImsiList", JSONArray(offImsiList))
        jsonObject.put("onImsiList", JSONArray(onImsiList))
        jsonObject.put("partnerCode", partnerCode)
        jsonObject.put("streamNo", streamNo)
        val body = jsonObject.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return execute { apiService.apiOnOffImsi(body,cookie,voipId,userLabel) }
    }

}