package com.example.allApi.data.api

import com.example.allApi.base.BaseResponse
import com.example.allApi.data.entirys.CountryDataBean
import com.example.allApi.data.entirys.DeviceDataBean
import com.example.allApi.data.entirys.OnOffImisDataBean
import okhttp3.RequestBody
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.Headers
import retrofit2.http.POST

interface ApiService {

    @Headers(
        "type_url:simBox",
        "Content-Type:application/json",
        "Partner-code:simbox",
        "Accept-Language:zh-CN",
        "langType:zh-CN",
        "App-Version:1.9.03"
    )
    @POST(ApiPath.QUERY_COVER_COUNTY_INFO)
    suspend fun apiQueryCountryInfo(@Body body: RequestBody, @Header("Cookie") cookie: String, @Header("voipId") voipId: String): BaseResponse<ArrayList<CountryDataBean>>


    @Headers(
        "type_url:simBox",
        "Content-Type:application/json",
        "Partner-code:simbox",
        "Accept-Language:zh-CN",
        "langType:zh-CN",
        "app-Version:1.9.03"
    )
    @POST(ApiPath.ON_OFF_IMSI)
    suspend fun apiOnOffImsi(@Body body: RequestBody, @Header("Cookie") cookie: String, @Header("voipId") voipId: String, @Header("userLabel") userLabel: String): BaseResponse<ArrayList<OnOffImisDataBean>>

    @Headers(
        "type_url:simBox",
        "Content-Type:application/json",
        "Partner-code:simbox",
        "Accept-Language:zh-CN",
        "langType:zh-CN",
        "app-Version:1.9.03"
    )
    @POST(ApiPath.QUERY_DEVICE_LIST)
    suspend fun apiQueryDeviceList(@Body body: RequestBody, @Header("Cookie") cookie: String, @Header("voipId") voipId: String, @Header("userLabel") userLabel: String): BaseResponse<ArrayList<DeviceDataBean>>



}