package com.example.simboxapi.data.api

import com.example.simboxapi.base.BaseResponse
import com.example.simboxapi.data.entirys.CountryDataBean
import com.example.simboxapi.data.entirys.OnOffImisDataBean
import okhttp3.RequestBody
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.Headers
import retrofit2.http.POST

interface ApiService {

    @Headers(
        "Content-Type:application/json",
        "Partner-code:simbox",
        "Accept-Language:zh-CN",
        "langType:zh-CN",
        "App-Version:1.9.03"
    )
    @POST("bss/app/noauth/QueryCoverCountyInfo")
    suspend fun apiQueryCountryInfo(@Body body: RequestBody, @Header("Cookie") cookie: String, @Header("voipId") voipId: String): BaseResponse<ArrayList<CountryDataBean>>


    @Headers(
        "Content-Type:application/json",
        "Partner-code:simbox",
        "Accept-Language:zh-CN",
        "langType:zh-CN",
        "app-Version:1.9.03"
    )
    @POST("bss/dsds/card/OnOffImsi")
    suspend fun apiOnOffImsi(@Body body: RequestBody, @Header("Cookie") cookie: String, @Header("voipId") voipId: String, @Header("userLabel") userLabel: String): BaseResponse<ArrayList<OnOffImisDataBean>>
}