package com.example.simboxapi.ui.queryDeviceList

import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.method.ScrollingMovementMethod
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.example.simboxapi.data.Status
import com.example.simboxapi.data.ViewModelFactory
import com.example.simboxapi.data.ViewModelRepository
import com.example.simboxapi.data.api.ApiClient
import com.example.simboxapi.databinding.ActivityQueryDeviceListBinding
import com.example.simboxapi.utils.StreamNoUtil
import com.google.gson.GsonBuilder

class QueryDeviceListActivity : AppCompatActivity(), View.OnClickListener {

    companion object {
        fun intentToQueryDeviceListActivity(context: Context) {
            val intent = Intent(context, QueryDeviceListActivity::class.java)
            context.startActivity(intent)
        }
    }

    private val mVB by lazy { ActivityQueryDeviceListBinding.inflate(layoutInflater) }
    private lateinit var mQueryDeviceListViewModel: QueryDeviceListViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initViewModel()
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnQueryDevicePostApi -> {

                val deviceType = ""
                val loginCustomerId = "6209e2ea1b7f0d319febe2b2"
                val partnerCode = "GCGROUP"
                val streamNo = "SIMBOX${StreamNoUtil.getData()}${((Math.random() * 9.toDouble() + 1.toDouble()) * 100000.toDouble()).toInt()}"

                val cookie = "access_token=TGT-2398391-2usdACdYsxPGbfXXnenVOIYRu6fZKFdZHpEAHczU0Sc4BfUZZR"
                val voidId = "80000076419"
                val userLabel = "businessUser"

                apiPostQueryDeviceList(deviceType, loginCustomerId, partnerCode, streamNo, cookie, voidId, userLabel)
            }
        }
    }

    private fun initViewModel() {
        val viewModelRepository: ViewModelRepository = ViewModelRepository.getInstance(ApiClient.getInstance(this).apiService)
        mQueryDeviceListViewModel = ViewModelProvider(this, ViewModelFactory.getInstance(viewModelRepository))[QueryDeviceListViewModel::class.java]
    }

    private fun initView() {
        mVB.tvQueryDevicePostApi.movementMethod = ScrollingMovementMethod()
        mVB.btnQueryDevicePostApi.setOnClickListener(this)
    }

    private fun apiPostQueryDeviceList(
        deviceType: String, loginCustomerId: String, partnerCode: String, streamNo: String,
        cookie: String, voipId: String, userLabel: String
    ) {
        mQueryDeviceListViewModel.apiPostQueryDeviceList(deviceType, loginCustomerId, partnerCode, streamNo, cookie, voipId, userLabel).observe(this) {
            when (it.status) {
                Status.SUCCESS -> {
                    if (it.data?.resultCode == "00000000") {
                        val data = GsonBuilder().setPrettyPrinting().create().toJson(it.data)
                        mVB.tvQueryDevicePostApi.text = data
                        return@observe
                    }
                    mVB.tvQueryDevicePostApi.text = it.data?.resultDesc ?: ""
                }
                Status.ERROR -> {
                    mVB.tvQueryDevicePostApi.text = it.e?.message.toString()
                }
                Status.LOADING -> {

                }
            }
        }
    }
}