package com.ost.micro.provider.controller;
import com.ost.micro.core.aop.DataToUnderline;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.core.pay.modules.sys.excel.BizBean;
import com.ost.micro.core.utils.ResponseUtils;
import com.ost.micro.provider.common.PaymentServiceClient;
import com.ost.micro.provider.common.ServiceUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/mch/tool")
@Api(tags = "查询工具接口")
public class ToolController {
    @Autowired
    private ConsulDiscoveryClient consulDiscoveryClient;
    @Autowired
    private PaymentServiceClient paymentServiceClient;
    @Autowired
    private ServiceUrl serviceUrl;

    @GetMapping("payorder")
    @ApiOperation("查询某条支付订单")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "order_no", value = "订单号", required = true, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = false, dataType = "Long")
    })
    @DataToUnderline()
    public DataResponse queryPayOrder(@RequestParam(name = "order_no") String orderNo, @RequestParam(required = false, name = "biz_id") Long bizId) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/tool/payorder");
        Map<String, Object> params = new HashMap<>();
        params.put("orderNo", orderNo);
        return paymentServiceClient.get(urlBuilder.toString(), params);

		/*ResponseEntity<DataResponse> result = paymentServiceClient.getRestTemplate()
				.getForEntity(urlBuilder.toString(), DataResponse.class, orderNo);
		return result.getBody();*/
    }

    @GetMapping("idcard")
    @ApiOperation("查询身份证")
    @ApiImplicitParam(paramType = "query", name = "id_no", value = "身份证号", required = true, dataType = "String")
    @DataToUnderline()
    public DataResponse queryIdCard(@RequestParam(name = "id_no") String idNo) {
        return ResponseUtils.getInstance().success(new BizBean());
    }

    @GetMapping("bankcard")
    @ApiOperation("查询银行卡")
    @ApiImplicitParam(paramType = "query", name = "card_no", value = "银行卡号", required = true, dataType = "String")
    @DataToUnderline()
    public DataResponse queryBankCard(@RequestParam(name = "card_no") String cardNo) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/tool/bankcard");
        Map<String, Object> params = new HashMap<>();
        params.put("cardNo", cardNo);
        return paymentServiceClient.get(urlBuilder.toString(), params);
    }
}
