package com.ost.micro.provider.common;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author Yubo
 */
@Slf4j
@Component
public class ServiceUrl {

    @Value("${spring.profiles.active}")
    private String environmentValue;

    /**
     * 开发环境和测试环境时使用
     * 远程调用as-service
     */
    public static final String LOCAL_DEV_URL_AS_SERVICE = "http://localhost:6020";
    @Value("${services.as-service}")
    private String asService;


    public static final ServiceUrl INSTANCE = new ServiceUrl();

    private ServiceUrl() {

    }

    /**
     * 远程调用as-service
     *
     * @param consulDiscoveryClient
     * @return
     */
    public String getAsServiceUrl(ConsulDiscoveryClient consulDiscoveryClient) {
        String serviceUrl = null;
        switch (environmentValue) {
            case "dev":
                serviceUrl = LOCAL_DEV_URL_AS_SERVICE;
                break;
            case "devv2":
                serviceUrl = LOCAL_DEV_URL_AS_SERVICE;
                break;
            case "test":
            case "sit":
                serviceUrl = LOCAL_DEV_URL_AS_SERVICE;
                break;
            // formal
            default:
                List<ServiceInstance> serviceInstanceList = consulDiscoveryClient.getInstances(asService);
                if (CollectionUtils.isEmpty(serviceInstanceList)) {
                    log.error("未找到服务========>" + asService);
                    return "";
                }
                ServiceInstance serviceInstance = serviceInstanceList.get(0);
                serviceUrl = serviceInstance.getUri().toString();
                log.info("as-service 服务地址为:========>{}", serviceUrl);
        }
        return serviceUrl;
    }
}
