/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.sys.service;
import com.ost.micro.common.page.PageData;
import com.ost.micro.common.service.BaseService;
import com.ost.micro.modules.sys.dto.SysUserDTO;
import com.ost.micro.modules.sys.dto.SysUserExtDTO;
import com.ost.micro.modules.sys.entity.SysUserEntity;

import java.util.List;
import java.util.Map;


/**
 * 系统用户
 * 
 * @author Mark sunlightcs@gmail.com
 */
public interface SysUserService extends BaseService<SysUserEntity> {

	PageData<SysUserExtDTO> page(Map<String, Object> params);

	List<SysUserDTO> list(Map<String, Object> params);

	SysUserDTO get(String id);

	SysUserExtDTO getByUsername(Map<String, Object> params);

	void save(SysUserDTO dto);

	void update(SysUserDTO dto);

	/**
	 * 修改密码
	 * @param id           用户ID
	 * @param newPassword  新密码
	 */
	void updatePassword(String id, String newPassword);

	/**
	 * 根据部门ID，查询用户数
	 */
	int getCountByDeptId(String deptId);
}
