/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.sys.dto;

import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 系统数据
 *
 * @author Mark sunlightcs@gmail.com
 * @since 1.0.0
 */
@ApiModel(value = "系统数据")
public class SystemDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    private Long sysTime;
    private String osName;
    private String osArch;
    private String osVersion;
    private String userLanguage;
    private String userDir;
    private Long totalPhysical;
    private Long freePhysical;
    private BigDecimal memoryRate;
    private Integer processors;
    private String jvmName;
    private String javaVersion;
    private String javaHome;
    private Long javaTotalMemory;
    private Long javaFreeMemory;
    private Long javaMaxMemory;
    private String userName;
    private BigDecimal systemCpuLoad;
    private String userTimezone;

    public Long getSysTime() {
        return sysTime;
    }

    public void setSysTime(Long sysTime) {
        this.sysTime = sysTime;
    }

    public String getOsName() {
        return osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsArch() {
        return osArch;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getUserLanguage() {
        return userLanguage;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage = userLanguage;
    }

    public String getUserDir() {
        return userDir;
    }

    public void setUserDir(String userDir) {
        this.userDir = userDir;
    }

    public Long getTotalPhysical() {
        return totalPhysical;
    }

    public void setTotalPhysical(Long totalPhysical) {
        this.totalPhysical = totalPhysical;
    }

    public Long getFreePhysical() {
        return freePhysical;
    }

    public void setFreePhysical(Long freePhysical) {
        this.freePhysical = freePhysical;
    }

    public BigDecimal getMemoryRate() {
        return memoryRate;
    }

    public void setMemoryRate(BigDecimal memoryRate) {
        this.memoryRate = memoryRate;
    }

    public Integer getProcessors() {
        return processors;
    }

    public void setProcessors(Integer processors) {
        this.processors = processors;
    }

    public String getJvmName() {
        return jvmName;
    }

    public void setJvmName(String jvmName) {
        this.jvmName = jvmName;
    }

    public String getJavaVersion() {
        return javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getJavaHome() {
        return javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public Long getJavaTotalMemory() {
        return javaTotalMemory;
    }

    public void setJavaTotalMemory(Long javaTotalMemory) {
        this.javaTotalMemory = javaTotalMemory;
    }

    public Long getJavaFreeMemory() {
        return javaFreeMemory;
    }

    public void setJavaFreeMemory(Long javaFreeMemory) {
        this.javaFreeMemory = javaFreeMemory;
    }

    public Long getJavaMaxMemory() {
        return javaMaxMemory;
    }

    public void setJavaMaxMemory(Long javaMaxMemory) {
        this.javaMaxMemory = javaMaxMemory;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public BigDecimal getSystemCpuLoad() {
        return systemCpuLoad;
    }

    public void setSystemCpuLoad(BigDecimal systemCpuLoad) {
        this.systemCpuLoad = systemCpuLoad;
    }

    public String getUserTimezone() {
        return userTimezone;
    }

    public void setUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
    }
}
