/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.sys.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ost.micro.common.utils.TreeNode;
import com.ost.micro.common.validator.group.AddGroup;
import com.ost.micro.common.validator.group.DefaultGroup;
import com.ost.micro.common.validator.group.UpdateGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 部门管理
 *
 * @author Mark sunlightcs@gmail.com
 * @since 1.0.0
 */
@ApiModel(value = "部门管理")
public class SysDeptDTO extends TreeNode implements Serializable {
    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	//@Null(message="{id.null}", groups = AddGroup.class)
	@NotBlank(message="{id.require}", groups = UpdateGroup.class)
	private String id;

	@ApiModelProperty(value = "上级ID")
	@NotBlank(message="{sysdept.pid.require}", groups = DefaultGroup.class)
	private String pid;

	/**
	 * 组织编号
	 */
	@ApiModelProperty(value = "组织编号")
	@NotBlank(message="{sysdept.deptNum.require}", groups = AddGroup.class)
	private String deptNum;


	@ApiModelProperty(value = "商家id")
	private String bizId;


	@ApiModelProperty(value = "备注")
	private String remark;


	@ApiModelProperty(value = "启用禁用 0:禁用 1:启用")
	private Integer status;


	@ApiModelProperty(value = "部门名称")
	@NotBlank(message="{sysdept.name.require}", groups = DefaultGroup.class)
	private String name;

	@ApiModelProperty(value = "排序")
	@Min(value = 0, message = "{sort.number}", groups = DefaultGroup.class)
	private Integer sort;

	@ApiModelProperty(value = "创建时间")
	@JsonProperty(access = JsonProperty.Access.READ_ONLY)
	private Date createDate;

	@ApiModelProperty(value = "上级部门名称")
	private String parentName;

	public void setName(String name) {
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void setSort(Integer sort) {
		this.sort = sort;
	}
	public Integer getSort() {
		return sort;
	}
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public Date getCreateDate() {
		return createDate;
	}

	public String getParentName() {
		return parentName;
	}

	public void setParentName(String parentName) {
		this.parentName = parentName;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getPid() {
		return pid;
	}

	@Override
	public void setPid(String pid) {
		this.pid = pid;
	}

	public String getDeptNum() {
		return deptNum;
	}

	public void setDeptNum(String deptNum) {
		this.deptNum = deptNum;
	}

	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
}