/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.security.oauth2;

import com.google.gson.Gson;
import com.ost.micro.common.constant.Constant;
import com.ost.micro.common.exception.ErrorCode;
import com.ost.micro.common.utils.HttpContextUtils;
import com.ost.micro.common.utils.Result;
import com.ost.micro.config.CustomFilterConfig;
import com.ost.micro.core.utils.GsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.yaml.snakeyaml.Yaml;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * oauth2过滤器
 *
 * @author Mark sunlightcs@gmail.com
 */
@Slf4j
@Component
public class Oauth2Filter extends AuthenticatingFilter {

    @Autowired
    private CustomFilterConfig customFilterConfig;

    private static Map<String, Map<String, Object>> properties;



    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        //获取请求token
        String token = getRequestToken((HttpServletRequest) request);

        if(StringUtils.isBlank(token)){
            return null;
        }

        return new Oauth2Token(token);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if(((HttpServletRequest) request).getMethod().equals(RequestMethod.OPTIONS.name())){
            return true;
        }
        return false;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        //读取yml数据
        HttpServletRequest httpServletRequest = (HttpServletRequest) request;
        String bizId = httpServletRequest.getHeader("bizId");
        getYml();
        Map<String, Object> urlFilter = properties.get("url-filter");
        Object domainsObject = urlFilter.get("domains");
        List<String> domainsList = new LinkedList<>();
        if (null != urlFilter) {
            String domainsStr = domainsObject.toString();
            if (domainsStr.indexOf(",") >= 0 ) {
                String[] domains = domainsStr.split(",");
                if (domains.length > 0) {
                    for (int i=0;i<domains.length ; i++) {
                        String itemInfo = domains[i];
                        if (org.apache.commons.lang.StringUtils.isNotEmpty(itemInfo)) {
                            String[] info = itemInfo.split(":");
                            String domain = info[0];
                            domainsList.add(domain);
                        }
                    }
                }
            }
        }
        log.info("解析配置文件域名信息结果为:{}", GsonUtil.toJson(domainsList,true));
        String url = request.getScheme()+"://"+request.getServerName();
        log.info("url is {}",url);

        // 判断是商户登录还是商家登录,通过url去判断
        String backstage = "";
        String backmch = "";

        if (domainsList.size() == 1 ) {
            backstage = org.apache.commons.lang.StringUtils.isEmpty(domainsList.get(0)) ?  "backstage":domainsList.get(0);
            backmch = "backmch";
        }
        if (domainsList.size() == 2 ) {
            backstage = org.apache.commons.lang.StringUtils.isEmpty(domainsList.get(0)) ?  "backstage":domainsList.get(0);
            backmch = org.apache.commons.lang.StringUtils.isEmpty(domainsList.get(1)) ?  "backmch":domainsList.get(1);
        }
        log.info("backmch is {} , bizId is {}",backmch,bizId);
        if (url.contains(backmch) && StringUtils.isEmpty(bizId)) {
            log.info("商家需要重新登录====");
            HttpServletResponse httpResponse = (HttpServletResponse) response;
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());
            String json = new Gson().toJson(new Result().error(ErrorCode.UNAUTHORIZED));
            httpResponse.getWriter().print(json);

            return false;
        }

        //获取请求token，如果token不存在，直接返回401
        String token = getRequestToken((HttpServletRequest) request);
        log.info(((HttpServletRequest) request).getRequestURL()+"请求的token为:{}",token);
        if(StringUtils.isBlank(token)){
            HttpServletResponse httpResponse = (HttpServletResponse) response;
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());

            String json = new Gson().toJson(new Result().error(ErrorCode.UNAUTHORIZED));

            httpResponse.getWriter().print(json);

            return false;
        }

        return executeLogin(request, response);
    }

    @Override
    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        httpResponse.setContentType("application/json;charset=utf-8");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());
        try {
            //处理登录失败的异常
            Throwable throwable = e.getCause() == null ? e : e.getCause();
            Result r = new Result().error(HttpStatus.SC_UNAUTHORIZED, throwable.getMessage());

            String json = new Gson().toJson(r);
            httpResponse.getWriter().print(json);
        } catch (IOException e1) {

        }

        return false;
    }

    /**
     * 获取请求的token
     */
    private String getRequestToken(HttpServletRequest httpRequest){
        //从header中获取token
        String token = httpRequest.getHeader(Constant.TOKEN_HEADER);

        //如果header中不存在token，则从参数中获取token
        if(StringUtils.isBlank(token)){
            token = httpRequest.getParameter(Constant.TOKEN_HEADER);
        }

        return token;
    }


    /**
     *
     * @throws FileNotFoundException
     */
    private void  getYml() throws FileNotFoundException {
        Yaml yaml = new Yaml();
        InputStream in  = Oauth2Filter.class.getClassLoader().getResourceAsStream("application.yml");
        if (in != null) {
            //获取test.yaml文件中的配置数据，然后转换为obj，
            properties = yaml.loadAs(in, HashMap.class);
        }
    }

}