package com.ost.micro.filter;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Component
public class UrlFilter extends ZuulFilter {
    @Override
    public String filterType() {
        return FilterConstants.PRE_TYPE ;
    }

    @Override
    public int filterOrder() {
        return 6;
    }

    @Override
    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        //String url = request.getScheme()+"://"+request.getServerName()+request.getRequestURI();
        String url = request.getRequestURL().toString();
        if (url.contains("login") || url.contains("logout") || url.contains("captcha") || url.contains("webjars") || url.contains("druid")
                || url.contains("swagger") || url.contains("/v2/api-docs") || url.contains("swagger-ui.html") || url.contains("/swagger-resources")
                || url.contains("service") || url.contains("editor-app") || url.contains("/diagram-viewer") || url.contains("modeler.html")
                || url.contains("favicon.ico") || url.contains("sys") || url.contains("actuator")) {
            return false;
        }
        return true;
    }

    @Override
    public Object run() throws ZuulException {
        log.info("开始进入UrlFilter zuul方法=======>");
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String originalRequestPath = request.getRequestURI().toString();
        String url = request.getScheme()+"://"+request.getServerName();
        log.info("request url is {}",url);
        if (url.contains("backstage")) {
            String modifiedRequestPath = "/api" + originalRequestPath;
            log.info("modifiedRequestPath is {}",modifiedRequestPath);
            ctx.put(FilterConstants.REQUEST_URI_KEY, modifiedRequestPath);
            ctx.set(FilterConstants.SERVICE_ID_KEY,"micro-project-as-pay-operation");
        }else if (url.contains("backmch")) {
            String modifiedRequestPath = "/mch" + originalRequestPath;
            log.info("modifiedRequestPath is {}",modifiedRequestPath);
            ctx.put(FilterConstants.REQUEST_URI_KEY, modifiedRequestPath);
            ctx.set(FilterConstants.SERVICE_ID_KEY,"micro-project-as-pay-merchant");
        }
        return null;
    }
}
