/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */
package com.ost.micro.util;

import org.apache.commons.lang.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 查询参数
 *
 * @author Mark sunlightcs@gmail.com
 */
public class Query extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    //当前页码
    private int page;
    //每页条数
    private int limit;

    public Query(Map<String, Object> params){
        this.putAll(params);
        if (null == params.get("page") || null == params.get("limit")) {
            this.put("offset", null);
            this.put("page", null);
            this.put("limit", null);
        }else {
            //分页参数
            this.page = Integer.parseInt(null == params.get("page") ? "1" : params.get("page").toString());
            this.limit = Integer.parseInt(null == params.get("limit") ? "10" : params.get("limit").toString());
            this.put("offset", (page - 1) * limit);
            this.put("page", page);
            this.put("limit", limit);
        }
    }


    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}
