package com.ost.micro.filter;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

//@Component
@Slf4j
public class AccessFilter extends ZuulFilter {
    @Override
    public String filterType() {
        return FilterConstants.PRE_TYPE;
    }

    @Override
    public int filterOrder() {
        return 0;
    }

    @Override
    public boolean shouldFilter() {
        return true;
    }

    @Override
    public Object run() throws ZuulException {
        log.info("开始进入zuul方法=======>");
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        //HttpServletResponse response = ctx.getResponse();
        Object originalRequestPath = ctx.get(FilterConstants.REQUEST_URI_KEY);
        Subject subject = SecurityUtils.getSubject();
        log.info("originalRequestPath is {}",originalRequestPath);
        String permission = urlToPermission(request.getRequestURI(),request);
        Boolean ispermission = subject.isPermitted(permission);
        if (!ispermission) {
            ctx.setSendZuulResponse(false);
            ctx.setResponseStatusCode(401);
            ctx.setResponseBody("{\"result\": 无访问权限! }");
            ctx.getResponse().setContentType("text/html;charset=UTF-8");
            return null;
        }

        //String modifiedRequestPath = "/api/prefix" + originalRequestPath;
        log.info("结束进入zuul方法=======>");
        return null;
    }


    /**
     * 权限标志定义
     * @param uri
     * @param request
     * @return
     */
    private String urlToPermission(String uri,HttpServletRequest request){
        String permission = "";
        if (StringUtils.isNotEmpty(uri)) {
            if (uri.startsWith("/api/")){
                uri = uri.replace("/api/","");
            }
            if (uri.startsWith("/mch/")){
                uri = uri.replace("/mch/","");
            }
            permission = uri.replaceAll("/",":");
            if (permission.startsWith(":")){
                permission = permission.replaceFirst(":","");
            }
            if (uri.lastIndexOf("/") > 0) {
                String lastParams = uri.substring(uri.lastIndexOf("/")+1,uri.length());
                Pattern pattern = Pattern.compile("\\d{19}");
                Matcher isNum = pattern.matcher(lastParams);
                if (isNum.matches()) {
                    String params = uri.substring(0,uri.lastIndexOf("/"));
                    permission = params+":info";
                }
            }
        }
        String method  = request.getMethod().toLowerCase();
        return permission+":"+method;
    }
}
