package com.ost.micro.provider.controller;

import com.ost.micro.common.aop.DataToUnderline;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.modules.cardservice.dto.passage.response.ApiResDto;
import com.ost.micro.provider.common.PaymentServiceClient;
import com.ost.micro.provider.common.ServiceUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 支付接口表
 *
 * @author rain
 * @email rain.guo@bytehug.com
 * @date 2019-08-13 16:40:46
 */
@RestController
@RequestMapping("/provider/card/payapi")
@Api(tags = "card支付接口表接口")
@Slf4j
public class CardApiController {
    @Autowired
    private PaymentServiceClient paymentServiceClient;
    @Autowired
    private ConsulDiscoveryClient consulDiscoveryClient;
    @Autowired
    private ServiceUrl serviceUrl;

    @GetMapping("list")
    @ApiOperation("列表")
    @ApiImplicitParam(paramType = "query", required = false, name = "payment_type", value = "支付方式 0-银行卡 1-固码汇旺财", dataType = "Integer")
    @DataToUnderline()
    public DataResponse<List<ApiResDto>> list(@RequestParam(required = false, name = "payment_type") Integer paymentType) {
        String apiUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/card/payapi/list";
        Map requestMap = new HashMap<>();
        if (null != paymentType) {
            requestMap.put("payment_type", paymentType);
        }
        return paymentServiceClient.get(apiUrl, requestMap);
    }

}
