package com.ost.micro.provider.common;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.export.ExcelExportService;
import com.google.gson.Gson;
import com.ost.micro.core.pay.modules.sys.dto.BizTradeDetailDto;
import com.ost.micro.core.pay.modules.sys.excel.BizTradeDetailBean;
import com.ost.micro.core.utils.CopyDataUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * excel工具类
 *
 * @author Mark sunlightcs@gmail.com
 * @since 2018-03-24
 */
public class ExcelBigUtils {

    private static final Integer MAX_SIZE = 10000;

    /**
     * Excel导出
     * 20W数据没问题，再多会卡死，需要继续优化
     *
     * @param response response
     * @param list     数据List
     */
    public static void exportExcel(HttpServletResponse response, String fileName, Collection<?> list) {
        try {

            List<String> fileNames = new ArrayList<>();  //存放生成的文件名称
            String filePath = "D:/excel/";                   //上线后切换成linux服务器地址
            if (!new File(filePath).exists()) {
                new File(filePath).mkdirs();
            }
            File zip = new File(filePath + fileName + ".zip");  //压缩文件路径

            List lists = (List) list;
            Integer pageNumeber = (lists.size() % MAX_SIZE == 0) ? lists.size() / MAX_SIZE : lists.size() / MAX_SIZE + 1;
            Gson gson = new Gson();
            List<BizTradeDetailBean> bizTradeDetailDtos = new ArrayList<>(10000);

            for (int i = 0; i < pageNumeber; i++) {
                String tempExcelFile = filePath + fileName + "[" + (i + 1) + "].xlsx";
                fileNames.add(tempExcelFile);
                FileOutputStream fos = new FileOutputStream(tempExcelFile);
                //int rowMemory = 100;
                SXSSFWorkbook workbook = new SXSSFWorkbook(100);
                ExportParams exportParams = new ExportParams();
                exportParams.setMaxNum(10000);
                exportParams.setType(ExcelType.XSSF);


                int minNum = i * MAX_SIZE;
                int maxNum = (i + 1) * MAX_SIZE;
                for (int j = minNum; j < (maxNum > lists.size() ? lists.size() : maxNum); j++) {
                    BizTradeDetailBean history = CopyDataUtil.copyObject(gson.fromJson(gson.toJson(lists.get(j)), BizTradeDetailDto.class), BizTradeDetailBean.class);
                    bizTradeDetailDtos.add(history);
                }
                //Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams(), BizTradeDetailDto.class, bizTradeDetailDtos);
                new ExcelExportService().createSheet(workbook, exportParams, BizTradeDetailBean.class, bizTradeDetailDtos);
                try {
                    workbook.write(fos);
                    fos.flush();
                    fos.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                bizTradeDetailDtos.clear();
            }
            exportZip(response, fileName, fileNames, zip);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void exportZip(HttpServletResponse response, String fileName, List<String> fileNames, File zip)
            throws IOException {
        response.reset();
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.addHeader("pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition",
                "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".zip");

        OutputStream outPut = response.getOutputStream();

        //1.压缩文件
        File srcFile[] = new File[fileNames.size()];
        for (int i = 0; i < fileNames.size(); i++) {
            srcFile[i] = new File(fileNames.get(i));
        }
        byte[] byt = new byte[1024];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));
        //out.setEncoding("UTF-8");
        for (int i = 0; i < srcFile.length; i++) {
            FileInputStream in = new FileInputStream(srcFile[i]);
            out.putNextEntry(new ZipEntry(srcFile[i].getName()));
            int length;
            while ((length = in.read(byt)) > 0) {
                out.write(byt, 0, length);
            }
            out.closeEntry();
            in.close();
        }
        out.close();

        //2.删除服务器上的临时文件(excel)
        for (int i = 0; i < srcFile.length; i++) {
            File temFile = srcFile[i];
            if (temFile.exists() && temFile.isFile()) {
                temFile.delete();
            }
        }

        //3.返回客户端压缩文件
        FileInputStream inStream = new FileInputStream(zip);
        byte[] buf = new byte[4096];
        int readLenght;
        while ((readLenght = inStream.read(buf)) != -1) {
            outPut.write(buf, 0, readLenght);
        }
        inStream.close();
        outPut.close();

        //4.删除压缩文件
        if (zip.exists() && zip.isFile()) {
            zip.delete();
        }
    }


}
