package com.ost.micro.provider.controller;

import com.ost.micro.core.aop.DataToUnderline;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.core.pay.modules.cardservice.dto.bank.response.BankResDto;
import com.ost.micro.provider.common.PaymentServiceClient;
import com.ost.micro.provider.common.ServiceUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Anson
 * @description:
 * @email anson.xu@bytehug.com
 * @date 2019/5/31  18:07
 */
@RestController
@Api(tags = "card银行")
@RequestMapping("/provider/card/bank")
@Slf4j
public class CardBankController {
    @Autowired
    private PaymentServiceClient paymentServiceClient;
    @Autowired
    private ConsulDiscoveryClient consulDiscoveryClient;
    @Autowired
    private ServiceUrl serviceUrl;

    @GetMapping("/list")
    @ApiOperation("列表")
    @ApiImplicitParam(paramType = "query", name = "is_out_bank", value = "是否出金银行0否1是", dataType = "Integer")
    @DataToUnderline()
    public DataResponse<List<BankResDto>> list(@RequestParam(required = false, name = "is_out_bank") Integer isOutBank) {

        String bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/card/bank/list";
        Map params = new HashMap();
        params.put("isOutBank", isOutBank);
        return paymentServiceClient.get(bankUrl, params);
    }

    @GetMapping("/type")
    @ApiOperation("聚合汇总银行列表")
    @DataToUnderline()
    public DataResponse<List<BankResDto>> type() {

        String bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/card/bank/type";
        return paymentServiceClient.get(bankUrl, new HashMap());
    }

}
